/***************************************************************************
 *
 * Copyright (c) 2012, NVIDIA CORPORATION.  All rights reserved.
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include "WindowSystems/BaseWindowSystem.h"
#include "Log.h"

void BaseWindowSystem::ClearDamage(int screenID)
{
    LmScreenList screenList = m_pScene->getScreenList();
    LOG_DEBUG("BaseWindowSystem", "Number of screens to clear=" << screenList.size());
    LmScreenListIterator iter = screenList.begin();
    LmScreenListIterator iterEnd = screenList.end();
    for (; iter != iterEnd; ++iter)
    {
        if (screenID != -1 && (*iter)->getID() != (unsigned int) screenID) { continue; }

        LayerList layers = m_pScene->getCurrentRenderOrder((*iter)->getID());
        for (LayerListIterator layer = layers.begin(); layer != layers.end(); layer++)
        {
            SurfaceList surfaces = (*layer)->getAllSurfaces();
            for (SurfaceListIterator surface = surfaces.begin(); surface != surfaces.end(); surface++)
            {
                LOG_DEBUG("BaseWindowSystem",
                          "screen ID=" << (*iter)->getID() << ", "
                          "layer ID=" << (*layer)->getID() << ", "
                          "surface ID=" << (*surface)->getID() << ", "
                          "surface sync=" << (*surface)->synchronized);
                // Clear Surface Damage
                (*surface)->damaged = false;
                (*surface)->renderPropertyChanged = false;
                if (true == (*surface)->ackClearDamage)
                {
                	m_pScene->sigSurfaceDamageClear();
                	(*surface)->ackClearDamage = false;
                }
            }
            // Clear Layer Damage
            (*layer)->damaged = false;
            (*layer)->renderPropertyChanged = false;
        }
    }
}
